---
title: Roles
weight: 4
type: security_practice
---

Throughout the core model and supporting documentation, we address the responsibilities associated with various teams and functional roles, such as the Information Security Team. Each organization has a unique structure and is likely to use different naming conventions. Here we provide explanations of how we use terms referring to teams and roles, and some guidance for you to align them with your assessment scenarios.

## The Organization

By organization we mean your entire enterprise, or a portion of it, as determined by the scope you have selected for your SAMM assessment. For example, if your assessment's scope is limited to the "Widgets" line of business, then read all references to "the organization" as "the Widgets line of business."

If the organization in scope for the assessment relies on groups outside the organization for all or part of a SAMM activity (e.g., a corporate Education Team manages all security awareness training), include the contributions from those groups when assessing your organization's maturity. 

## Stakeholder

Stakeholder refers to any party that can affect or be affected by your organization's actions, with regard to the applications within your assessment scope. Stakeholders in application development frequently include business owners, product owners, managers, developers, testers, infrastructure teams, regulatory agencies, standards organizations, certification assessors, and third-party suppliers.

## Teams

### Administration Team

The Administration Team includes all individuals and job functions responsible for managing the collection of systems, networks, and other resources the applications within your assessment scope depend on. In some cases, the Administration Team will be external to the organization defined by your assessment scope and perform these job functions as a service to your organization. In others, the Administration Team may be the same as the Product Team, with members assigned various administration functions as part of their full-stack responsibilities.

### Product Team

The Product Team includes all individuals and job functions responsible for developing and delivering software applications within the assessment scope.

## Individual Roles

### Administrator

As used within the model, 'administrator' refers to the individual or job function assigned responsibility for managing one or more specific systems, networks, or other resources on which at least one application within your assessment scope depends. Administrators include all individuals handling these responsibilities, whether dedicated to such roles full-time or assigned them as part of "full stack" development.

Administrator refers to the individual or job function responsible for managing one or more specific systems, networks, or other resources any application within your assessment scope depends on. Administrators include all individuals handling these responsibilities, whether dedicated to such roles full-time, part-time, or as an additional duty in a full-stack development role.

### Analyst

The Analyst role involves collecting, reviewing, and documenting security and application architectures, evaluating threats and security risks, and consulting with architects, developers, and business partners to gather information, perform analysis, and remediate identified security issues. The Analyst is expected to be fully aware of the organization’s security goals established by its policies, procedures, and guidelines, and to actively work towards upholding these goals.

The Analyst often works with key stakeholders across multiple business units to enhance the security of the business enterprise. They interact with management teams to communicate identified security issues and their impact on the organization. It is also important that the Analyst contributes to the security enhancement of the Software Development Lifecycle (SDLC) and the Vulnerability and Threat Management Program.

### Application Security Professional



### Architect

Understand how applications fit into a multi-tiered architecture

Enhance awareness of risk outside the application

An architect must integrate particular security controls at the right locations within the  application landscape. 

The relevant audience is interested in exploring architectural features of software that should be included to mitigate mobile application operational risks related to application integrity violation.

Often, security architects have to describe how their security solution impacts the CIA model. This is required because each control may have security impacts on maintaining the confidentiality, integrity, and availability of the application’s code and data.


### Developer



### Manager



### Product Owner



### Security Champion



### Security Officer



### Tester


